fs.video = (function() {

    var player,
		config = {
			defaultPlayer	: 'html5',
			canvasMode		: false
		};

	var defPlayer = config.defaultPlayer;

    return {

        init: function(playerId, base, media) {

			if ( !media ) return;

// this.playerType = 'flash';
 this.playerType = 'html5';

            this.playerId = playerId;
            this.base	= base;
            this.media	= media;

            player = fs.video[ this.playerType ].init(this.playerId, this.base, this.media);
            player.bindEvent();

            if (this.base.slide > 0) this.setSlide(this.base.slide);
            if (this.base.pos   > 0) this.setPos(this.base.pos);
        },

        getPlayerId: function() { return player.getPlayerId(); },

        defaultPlayer: function(type) {
            if (typeof fs.video[type] == 'undefined') return false;
            localStorage.setItem('defaultPlayer', type);
        },

        focus: function() {
            $('#' + this.playerId).focus();
        },

        type: function() {
            return player.type;
        },

        width: function() {
            return $('#' + this.playerId).width();
        },
        height: function() {
            return $('#' + this.playerId).height();
        },

        play: function() {
            player.play();
        },
        pause: function() {
            player.pause();
        },

        getPos: function() {
            return player.getPos();
        },
        setPos: function(pos) {
            player.setPos(pos);
        },

        getSlide: function() {
            return player.getSlide();
        },
        setSlide: function(slide) {
            player.setSlide(slide);
        },

        appendElement: function(obj) {
            player.appendElement(obj);
        },

        isFullscreen: function() {
            return player.isFullscreen();
        },

        isReady: function() {
            return player.isReady();
        },
        changePlayer: function(type) {

            if (type == player.type) return;

			localStorage.setItem('defaultPlayer', type);

			var pos = player.getPos();

            player.destory();

			delete player;

			var base = this.base;
			base.pos = pos;

			var self = this;

			fs.event.register('player.start', function(){

				if (base.slide)	self.setSlide(base.slide);
				if (base.pos)	self.setPos(base.pos);

				fs.event.trigger('player.playerChanged', type);
			});

            player = fs.video[type].init(this.playerId, base, this.media);
            player.bindEvent();
        },

        changeSourceFromUrl: function(url) {

            var self = this;

            $.post(url, {}, function(obj) {

                player.changeSource(obj, function() {
                    self.init(self.playerId, obj.base, obj.media);
                });

            }, 'json')
        },

        canvasMode: function( stat ) {

			if ( typeof stat == 'undefined' ) {
				return player.canvasMode();
			}

            (stat) ? player.enableCanvasMode() : player.disableCanvasMode();

			localStorage.setItem('canvasMode', stat);

            return stat;
        },
		
		resizeProgressBar: function(){
			player.resizeProgressBar();
		},

		config : config

    };
})();


fs.video.html5 = (function() {

    var player;
    var playerId;

	var tryTime = 0,
		tryLimit= 5;

    var html5PlayerReady = false;
    return {
        type: 'html5',
        getPlayerId: function() {
            return playerId;
        },
        init: function(id, base, data) {
            playerId = id;
            var wrap = $('#' + playerId);
            player = wrap.jQPlayer({

                controls: ['separator', 'play', 'separator', 'leftRadius', 'index', 'progress', 'storyboard', 'volume', 'playback', 'resolution', 'fullscreen', 'stretch', 'time', 'rightRadius', 'separator'],

                storyboard	: ( data.storyboard ) ? data.storyboard : "",
                duration	: data.duration,
                video		: data.src,
                index		: data.index,
                poster		: data.poster,

                onTimeUpdate: function(currentTime) {
                    fs.event.trigger('player.timeUpdate', currentTime);
                },
                onIndexChange: function(index) {
                    fs.event.trigger('player.indexChange', index);
                },

                onVolumeChange: function(volume) {
                    localStorage.setItem('player.volume', volume);
                    fs.event.trigger('player.volumeChange', volume);
                },

                onVideoReady: function(api) {

                    var volume = localStorage.getItem('player.volume');

                    if (!volume) {
                        volume = 1;
                        localStorage.setItem('player.volume', volume);
                    }

                    api.setVolume(volume);

					var canvasMode = localStorage.getItem('canvasMode');
					if ( canvasMode == 'true' ) {
						api.enableCanvasMode();
					}

                    fs.event.trigger('player.videoReady');
                    html5PlayerReady = true;
                },

                onFullscreen: function(status) {
                    fs.event.trigger('player.fullscreen', status);
                },

                onModeChange: function(isCanvas) {
                    localStorage.setItem('canvasMode', isCanvas);
                    fs.event.trigger('player.onModeChange', isCanvas);
                },

                onEnd: function() {
                    fs.event.trigger('player.end');
                }
            });

            return this;
        },

        bindEvent: function() {

            fs.event.register('canplay', function() {
                $(window).trigger('resize');
            });

            $(window).resize(function() {
                fs.event.trigger('player.reposition');
            });
        },

        resizeProgressBar: function() {
            player.resizeProgressBar();
        },
        play: function() {
            player.play();
        },
        pause: function() {
            player.pause();
        },

        getPos: function() {
            return player.getCurrTime();
        },

        setPos: function( pos ) {

			if ( tryTime > tryLimit ) {
				tryTime = 0;
				return false;
			}

			var self = this;

			setTimeOut(function(){

				var state = player.setCurrTime(pos);

				if ( state !== false ) return true;

				tryTime++;

				self.setPos( pos );

			}, 500);
        },

        getSlide: function() {
            return player.currentIndex;
        },
        setSlide: function(slide) {
            player.setIndex(slide);
        },

        appendElement: function(o) {
            player.appendElement(o);
        },

        isFullscreen: function() {
            return player.fullscreen;
        },

        changeSource: function(data, cb) {

            this.destory();
            cb.call();
        },

        isReady: function() {

            return html5PlayerReady;
        },

        destory: function() {

            $('#' + playerId).find('video').attr('src', '');
            $('#' + playerId).empty();

			$('#' + playerId).unbind('contextmenu mousedown');

            delete playerId;
            delete player;
        },

		canvasMode : function(){ return player.canvasMode; },

		enableCanvasMode	: function(){player.enableCanvasMode();  },
		disableCanvasMode	: function(){ player.disableCanvasMode(); }
    };
})();
